IF EXISTS (SELECT * FROM SYS.PROCEDURES WHERE NAME ='P_LIBERA_VD_CONV_PDV_VD_IT_EST_PROD_LIBERA_PGTO_CONV')
    BEGIN 
	   DROP PROCEDURE P_LIBERA_VD_CONV_PDV_VD_IT_EST_PROD_LIBERA_PGTO_CONV 
    END

GO
CREATE PROCEDURE P_LIBERA_VD_CONV_PDV_VD_IT_EST_PROD_LIBERA_PGTO_CONV 
AS

SET NOCOUNT ON;

DECLARE @DT_VD DATE = DATEADD(DAY,-5,GETDATE()); ;

WHILE @DT_VD < CONVERT(DATE, GETDATE())
BEGIN

	PRINT 'Processando o dia ' + CONVERT(VARCHAR, @DT_VD , 112);
	UPDATE IT
	  SET
		  LIBERA_VD_CONV = ISNULL((SELECT DBO.UFD_EST_PROD_LIBERA_PGTO_CONV(IT.CD_EMP, IT.CD_FILIAL, IT.CD_PROD, V.CD_CLI, V.CD_CONV, 0)), 1)
	FROM PDV_VD V
		 JOIN PDV_VD_IT IT ON V.CD_EMP = IT.CD_EMP
							  AND V.CD_FILIAL = IT.CD_FILIAL
							  AND V.CD_VD = IT.CD_VD
							  AND V.DT_VD = IT.DT_VD
	WHERE
		  IT.DT_VD = @DT_VD
		  AND IT.CD_EMP = 1
		  AND IT.LIBERA_VD_CONV IS NULL; 
	SET @DT_VD = DATEADD(DAY,1, @DT_VD);
END
